function [xout, min_idx] = find_phase(ximg, Nlines_vec, points)
n = 400;
Pha = (Nlines_vec.'/points)*2*pi*(-n/2:n/2 - 1)/n;
xout = zeros(size(ximg));
min_idx = zeros(1, size(ximg, 2));
for j = 1:size(ximg, 2)
    D = ximg(:, j)*ones(1, n).*exp(1j*Pha);
    F = ifftc(D);
    res = mean(abs(F));
    %     res = mean(log(abs(F)));
    [~, J] = min(res);
    xout(:, j) = F(:, J);
    min_idx(j) = J;
end
